VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Begin VB.Form Form1 
   BackColor       =   &H00C0FFC0&
   Caption         =   "U3800 Power Trend Ver. 1.0"
   ClientHeight    =   5745
   ClientLeft      =   3360
   ClientTop       =   1980
   ClientWidth     =   6690
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5745
   ScaleWidth      =   6690
   Begin VB.CommandButton Measurement 
      BackColor       =   &H00C0FFFF&
      Caption         =   "Measurement  (Power Trend)"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   1320
      MaskColor       =   &H8000000F&
      Style           =   1  'Graphical
      TabIndex        =   14
      ToolTipText     =   "Open the measurement menu"
      Top             =   1320
      Width           =   4095
   End
   Begin VB.CheckBox Monitor 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Monitor"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5160
      TabIndex        =   11
      ToolTipText     =   "Monitor display ON"
      Top             =   4920
      Width           =   1095
   End
   Begin VB.ListBox lstRecv 
      Height          =   1815
      ItemData        =   "Form1.frx":0442
      Left            =   240
      List            =   "Form1.frx":0444
      TabIndex        =   7
      Top             =   2280
      Width           =   6135
   End
   Begin ComctlLib.StatusBar sbrMessage 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   6
      Top             =   5430
      Width           =   6690
      _ExtentX        =   11800
      _ExtentY        =   556
      Style           =   1
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdDisConn 
      Caption         =   "Close"
      Height          =   375
      Left            =   5280
      TabIndex        =   5
      ToolTipText     =   "Close the Host SPA"
      Top             =   480
      Width           =   1035
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "SendText"
      Height          =   315
      Left            =   3720
      TabIndex        =   4
      ToolTipText     =   "Send the commands to the SPA"
      Top             =   4920
      Width           =   1155
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Connect"
      Height          =   375
      Left            =   3720
      TabIndex        =   3
      ToolTipText     =   "Connect to the Host SPA"
      Top             =   480
      Width           =   1035
   End
   Begin VB.TextBox txtPort 
      Height          =   270
      Left            =   2460
      TabIndex        =   2
      Text            =   "5025"
      Top             =   420
      Width           =   735
   End
   Begin VB.TextBox txtSend 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000007&
      Height          =   315
      Left            =   360
      TabIndex        =   1
      Text            =   "*RST"
      Top             =   4920
      Width           =   3075
   End
   Begin VB.TextBox txtHost 
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Text            =   "192.168.0.1"
      Top             =   420
      Width           =   2115
   End
   Begin MSWinsockLib.Winsock tcpClient 
      Left            =   480
      Top             =   1320
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Line Line5 
      BorderColor     =   &H8000000D&
      X1              =   240
      X2              =   6360
      Y1              =   1080
      Y2              =   1080
   End
   Begin VB.Line Line4 
      BorderColor     =   &H8000000D&
      X1              =   5520
      X2              =   6360
      Y1              =   240
      Y2              =   240
   End
   Begin VB.Line Line3 
      BorderColor     =   &H8000000D&
      X1              =   3600
      X2              =   4440
      Y1              =   240
      Y2              =   240
   End
   Begin VB.Label Label3 
      BackColor       =   &H00C0FFC0&
      Caption         =   "LAN Port"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   4560
      TabIndex        =   13
      Top             =   120
      Width           =   855
   End
   Begin VB.Line Line2 
      BorderColor     =   &H8000000D&
      X1              =   3960
      X2              =   6360
      Y1              =   4440
      Y2              =   4440
   End
   Begin VB.Line Line1 
      BorderColor     =   &H8000000D&
      X1              =   240
      X2              =   2640
      Y1              =   4440
      Y2              =   4440
   End
   Begin VB.Label Label2 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Test Mode"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   2880
      TabIndex        =   12
      Top             =   4320
      Width           =   975
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Sending Text (GPIB Command)"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Index           =   2
      Left            =   600
      TabIndex        =   10
      Top             =   4680
      Width           =   2775
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Port No."
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   1
      Left            =   2460
      TabIndex        =   9
      Top             =   120
      Width           =   855
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Host Address"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   0
      Left            =   240
      TabIndex        =   8
      Top             =   120
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'*----------------------------------------------------------------------
'*.Program Name :        Power_Trend
'*
'*      Sample software for Advantest Spectrum Analyzer U37xx
'*
'*.Description :
'*
'*.Revision History :
'*      1.00           20-Mar-2006     First  Release. by Hirakoso
'*      1.10           01-Apr-2010     2nd    Release. by Hirakoso
'*                     ;Addtion Auto Save/Recall IP and Port Address
'*
'*      U3800 V10      07-Dec-2011      V1.0  Release for U3800
'*                                              by Hirakoso
'*
'*
'*----------------------------------------------------------------------
'*.Copyright(c) 2006,2011 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*----------------------------------------------------------------------


Private Sub cmdDisConn_Click()
    Dim iintLoop As Integer, ErrRet As Integer

    ErrRet = SendDtFunc("GTL" & vbLf)
    tcpClient.Close
    cmdConnect.Enabled = True
    cmdConnect.Default = True
    txtHost.Enabled = True
    txtPort.Enabled = True
    
    Form1.sbrMessage.SimpleText = "Closed"
    
    SetupLAN = 0                                ' Clear connect flag

    cmdDisConn.Enabled = False
    
End Sub


Private Sub cmdConnect_Click()
Dim Sp As String
Dim SendDt As String, ErrRet As Integer
    
    If Trim$(txtHost.Text) <> "" And _
      Trim$(txtPort.Text) <> "" Then
                                                 'AvP[Vɐڑv𑗐M܂
        tcpClient.Protocol = sckTCPProtocol
        tcpClient.LocalPort = 0
        tcpClient.RemoteHost = txtHost.Text
        tcpClient.RemotePort = txtPort.Text
        tcpClient.Connect
        txtSend.SetFocus
            
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
        Loop
        tcpClient.GetData Sp
        Form1.lstRecv.AddItem tcpClient.RemoteHost & "-->" & Sp
        ErrRet = SendDtFunc("REN" & vbLf)
        
        Form1.sbrMessage.SimpleText = "Connected"
        cmdConnect.Enabled = False
        cmdDisConn.Enabled = True
        Measurement.Default = True
        
        SetupLAN = 1                                ' set connect flag
    
    Else
        MsgBox "Please input the IP Address"
        SetupLAN = 0                                ' Clear connect flag
        
    End If
End Sub


Private Sub cmdSend_Click()
Dim SendDt As String, ErrRet As Integer
Dim dt As String
Dim iErrFg As Integer
Dim dTimer As Double


If SetupLAN = 1 Then                                ' Connect is OK

    SendDt = "REN" + vbLf                           'Remote ON
    ErrRet = SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub

    SendDt = txtSend.Text + vbLf
    ErrRet = SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    If InStr(SendDt, "?") > 0 Then
    
        dTimer = Timer
        iErrFg = 0
        
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
            If Timer > dTimer + 3# Then             ' Wait 3 sec
                iErrFg = 1
                Exit Do
            End If
        Loop
        
        If iErrFg = 0 Then
            ErrRet = ReadDtFunc(dt)
            If ErrRet <> 0 Then Exit Sub
        Else
            Form1.sbrMessage.SimpleText = "No data... Please send Query command."
        End If

    End If
    
Else

    MsgBox "Please open the LAN: Connect button..."

End If

    
End Sub


Public Function ReadDtFunc(dt As String) As Integer
    Dim ipErr As Long
    
    ReadDtFunc = 0
    On Error GoTo ErrOcc
    ipErr = 0

    Form1.sbrMessage.SimpleText = "Reading..."
    
    Do While (tcpClient.BytesReceived = 0)              '@킩f[^H
        DoEvents
    Loop
    tcpClient.GetData dt                                '@킩f[^܂B
    
    If ipErr <> 0 Then
        ReadDtFunc = 1
        Exit Function
    End If

    If Form1.Monitor.Value = 1 Then
        Form1.lstRecv.AddItem tcpClient.RemoteHost & "-->" & dt
        Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
    End If
    
    Exit Function

ErrOcc:
    ipErr = Err.Number
    Form1.lstRecv.AddItem Format(Err.Number) & Err.Description
    Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
    Resume Next

End Function


Public Function SendDtFunc(dt As String) As Integer
    Dim ipErr As Long
    
    SendDtFunc = 0
    On Error GoTo ErrOcc
    ipErr = 0
    
    Form1.sbrMessage.SimpleText = "Sending..."
                                                'AvP[VɃf[^𑗐M܂
    tcpClient.SendData dt
    
    If ipErr <> 0 Then
        SendDtFunc = 1
        Exit Function
    End If
    
    If Form1.Monitor.Value = 1 Then
        Form1.lstRecv.AddItem tcpClient.RemoteHost & "<--" & dt
        Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
    End If

    Exit Function

ErrOcc:
    ipErr = Err.Number
    Form1.lstRecv.AddItem Format(Err.Number) & Err.Description
    Form1.lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
    Resume Next

End Function


Private Sub Form_Load()

    InitRecall                                          'Recall previous data

    MeasFlag = 0
    
    cmdDisConn.Enabled = False
    

End Sub

Private Sub Measurement_Click()

    If SetupLAN = 1 Then
    
        ' FormMeas.Visible = True
        FormMeas.Show vbModal
        
    Else
    
        MsgBox "Please open the LAN: Connect button..."
        
    End If
    

End Sub
